package io.jmix.petclinic.entity;

import io.jmix.core.metamodel.annotation.InstanceName;
import io.jmix.core.metamodel.annotation.JmixEntity;

import javax.persistence.*;

@JmixEntity
@Table(name = "AGENCY")
@Entity(name = "AGENCY")
public class Agency {
    @Column(name = "AGENCY_ID", nullable = false)
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long agencyId;

    @InstanceName
    @Column(name = "AGENCY_NAME")
    private String agencyName;

    @Column(name = "AGENCY_CODE")
    private String agencyCode;

    @OneToOne(mappedBy = "agency", fetch = FetchType.LAZY)
    private Repokit repokit;

    public Long getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = agencyId;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getAgencyCode() {
        return agencyCode;
    }

    public void setAgencyCode(String agencyCode) {
        this.agencyCode = agencyCode;
    }

    public Repokit getRepokit() {
        return repokit;
    }

    public void setRepokit(Repokit repokit) {
        this.repokit = repokit;
    }
}