package com.company.testproject.view.a;

import com.company.testproject.entity.A;
import com.company.testproject.entity.B;
import com.company.testproject.view.main.MainView;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.icon.Icons;
import io.jmix.flowui.kit.icon.JmixFontIcon;
import io.jmix.flowui.view.*;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value = "as/:id", layout = MainView.class)
@ViewController(id = "A.detail")
@ViewDescriptor(path = "a-detail-view.xml")
@EditedEntityContainer("aDc")
public class ADetailView extends StandardDetailView<A> {

    @Autowired
    private Icons icons;

    @Supply(to = "childDataGrid.principal", subject = "renderer")
    private Renderer<B> childDataGridPrincipalRenderer() {
        return new ComponentRenderer<>(b -> Boolean.TRUE.equals(b.getPrincipal())
                ? icons.get(JmixFontIcon.CHECK_SQUARE_O)
                : icons.get(JmixFontIcon.THIN_SQUARE));
    }

    @Subscribe
    public void onBeforeSave(final BeforeSaveEvent event) {
        if (getEditedEntity().getChild().stream().filter(B::getPrincipal).count() != 1) {
            throw new RuntimeException("Must define 1 principal child");
        }
    }
}