package com.company.comboboxissue.view.myentity;

import com.company.comboboxissue.entity.MyEntity;
import com.company.comboboxissue.view.main.MainView;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.List;
import java.util.stream.Stream;

@Route(value = "my-entities/:id", layout = MainView.class)
@ViewController(id = "MyEntity.detail")
@ViewDescriptor(path = "my-entity-detail-view.xml")
@EditedEntityContainer("myEntityDc")
public class MyEntityDetailView extends StandardDetailView<MyEntity> {
    List<String> emptyList = List.of();
    List<String> nonEmptyList = List.of("Item1", "Item2", "Item3");

    @Install(to = "mandaryFieldField", subject = "itemsFetchCallback")
    private Stream<String> mandaryFieldFieldItemsFetchCallback(final Query<String, String> query) {
        String userInput = query.getFilter().orElse("").toLowerCase();

        return emptyList.stream()
            .filter(item -> item.toLowerCase().contains(userInput))
            .skip(query.getOffset())
            .limit(query.getLimit());
    }

    @Install(to = "anotherMandatoryField", subject = "itemsFetchCallback")
    private Stream<String> anotherMandatoryFieldItemsFetchCallback(final Query<String, String> query) {
        String userInput = query.getFilter().orElse("").toLowerCase();

        return nonEmptyList.stream()
            .filter(item -> item.toLowerCase().contains(userInput))
            .skip(query.getOffset())
            .limit(query.getLimit());
    }
}