package com.company.filter.entity;

import io.jmix.core.metamodel.annotation.InstanceName;
import io.jmix.core.metamodel.annotation.JmixEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;

@JmixEntity
@Table(name = "T_OBJECT", indexes = {
		@Index(name = "IDX_T_OBJECT_OBJIDCOLLECTION", columnList = "objIdCollection")
})
@Entity
public class TObject {
	@Column(name = "objIdObject", nullable = false)
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;

	@JoinColumn(name = "objIdCollection", nullable = false)
	@NotNull
	@ManyToOne(fetch = FetchType.LAZY, optional = false)
	private TCollection objIdCollection;

	@InstanceName
	@Column(name = "objCommonName", nullable = false)
	@NotNull
	private String objCommonName;

	public String getObjCommonName() {
		return objCommonName;
	}

	public void setObjCommonName(String objCommonName) {
		this.objCommonName = objCommonName;
	}

	public TCollection getObjIdCollection() {
		return objIdCollection;
	}

	public void setObjIdCollection(TCollection objIdCollection) {
		this.objIdCollection = objIdCollection;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

}