package com.company.filter.view.tobject;

import com.company.filter.entity.TCollection;
import com.company.filter.entity.TObject;
import com.company.filter.view.main.MainView;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.Registration;
import io.jmix.core.DataManager;
import io.jmix.core.metamodel.model.MetaPropertyPath;
import io.jmix.flowui.component.genericfilter.GenericFilter;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.logicalfilter.LogicalFilterComponent;
import io.jmix.flowui.component.propertyfilter.PropertyFilter;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.view.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;


@Route(value = "t-objects", layout = MainView.class)
@ViewController(id = "TObject.list")
@ViewDescriptor(path = "t-object-list-view.xml")
@LookupComponent("tObjectsDataGrid")
@DialogMode(width = "64em")
public class TObjectListView extends StandardListView<TObject> {

    @Autowired
    protected DataManager dataManager;
    @ViewComponent
    private DataGrid<TObject> tObjectsDataGrid;

    Integer selectedCollectionId = null;
    private PropertyFilter<?> collectionFilter;
    private Registration collectionFilterRegistration;

    @Subscribe
    public void onReady(ReadyEvent event) {
        tObjectsDataGrid.getActions().forEach(Action::refreshState);
    }

    @Subscribe("genericFilter")
    public void onGenericFilterConfigurationRefresh(final GenericFilter.ConfigurationRefreshEvent event) {
        LogicalFilterComponent<?> rootFilterComponent = event.getUpdatedConfiguration().getRootLogicalFilterComponent();

        PropertyFilter<?> collectionFilter = rootFilterComponent.getOwnFilterComponents().stream()
                .filter(filterComponent -> filterComponent instanceof PropertyFilter<?>)
                .map(filterComponent -> ((PropertyFilter<?>) filterComponent))
                .filter(filterComponent -> "objIdCollection".equals(filterComponent.getProperty()))
                .findAny()
                .orElse(null);

        // your value
        if (collectionFilter != null) {
            if (collectionFilterRegistration != null) {
                collectionFilterRegistration.remove();
                collectionFilterRegistration = null;
            }

            collectionFilterRegistration = collectionFilter.addValueChangeListener(
                    __ -> tObjectsDataGrid.getAction("createAction").refreshState()
            );
            this.collectionFilter = collectionFilter;
        }
    }

    @Install(to = "tObjectsDataGrid.createAction", subject = "enabledRule")
    private boolean tObjectsDataGridCreateActionEnabledRule() {
        return collectionFilter != null && collectionFilter.getValue() != null;
    }

    @Install(to = "tObjectsDataGrid.createAction", subject = "initializer")
    private void tObjectsDataGridCreateActionInitializer(final TObject tObject) {
        if (selectedCollectionId != null) {
            TCollection collection = dataManager.create(TCollection.class);
            collection.setId(selectedCollectionId);
            tObject.setObjIdCollection(collection);
        }
    }

}