package com.company.tempupload.uploadhandler;

import com.vaadin.flow.server.streams.*;
import io.jmix.flowui.upload.TemporaryStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

import java.io.*;

@Component("app_TemporaryStorageUploadHandler")
@Scope(BeanDefinition.SCOPE_PROTOTYPE)
public class TemporaryStorageUploadHandler extends TransferProgressAwareHandler<UploadEvent, TemporaryStorageUploadHandler>
        implements UploadHandler {

    private static final Logger log = LoggerFactory.getLogger(TemporaryStorageUploadHandler.class);

    private final TemporaryStorage temporaryStorage;

    private TemporaryStorage.FileInfo fileInfo;

    public TemporaryStorageUploadHandler(TemporaryStorage temporaryStorage) {
        this.temporaryStorage = temporaryStorage;
    }

    @Override
    public void handleUploadRequest(UploadEvent event) throws IOException {
        try (InputStream inputStream = event.getInputStream()) {
            fileInfo = temporaryStorage.createFile();

            OutputStream fileOutputStream = createFileOutputStream(fileInfo.getFile());

            TransferUtil.transfer(
                    inputStream,
                    fileOutputStream,
                    getTransferContext(event),
                    getListeners());
        } catch (IOException e) {
            notifyError(event, e);
            log.error("Failed to upload file", e);
        }
    }

    @Nullable
    public TemporaryStorage.FileInfo getFileInfo() {
        return fileInfo;
    }

    protected OutputStream createFileOutputStream(File file) {
        try {
            return new FileOutputStream(file);
        } catch (FileNotFoundException e) {
            throw new IllegalStateException("Failed to create temporary file output stream", e);
        }
    }

    @Override
    protected TransferContext getTransferContext(UploadEvent transferEvent) {
        return new TransferContext(
                transferEvent.getRequest(),
                transferEvent.getResponse(),
                transferEvent.getSession(),
                transferEvent.getFileName(),
                transferEvent.getOwningElement(),
                transferEvent.getFileSize());
    }
}
