package com.company.tempupload.view.sandbox;

import com.company.tempupload.uploadhandler.TemporaryStorageUploadHandler;
import com.company.tempupload.view.main.MainView;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.streams.TransferContext;
import io.jmix.core.FileRef;
import io.jmix.flowui.component.upload.JmixUpload;
import io.jmix.flowui.upload.TemporaryStorage;
import io.jmix.flowui.view.*;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value = "sandbox-view", layout = MainView.class)
@ViewController(id = "SandboxView")
@ViewDescriptor(path = "sandbox-view.xml")
public class SandboxView extends StandardView {

    @Autowired
    private TemporaryStorage temporaryStorage;

    @ViewComponent
    private JmixUpload upload;
    @ViewComponent
    private Span uploadedFileSpan;

    private TemporaryStorageUploadHandler tempUploadHandler;
    private FileRef fileRef;

    @Subscribe
    public void onInit(final InitEvent event) {
        tempUploadHandler = getApplicationContext().getBean(TemporaryStorageUploadHandler.class);
        tempUploadHandler.whenComplete(this::onFileUploadComplete);

        upload.setUploadHandler(tempUploadHandler);
    }

    private void onFileUploadComplete(TransferContext transferContext, Boolean success) {
        TemporaryStorage.FileInfo fileInfo = tempUploadHandler.getFileInfo();
        if (success && fileInfo != null) {
            fileRef = temporaryStorage.putFileIntoStorage(fileInfo.getId(), transferContext.fileName());

            uploadedFileSpan.setText(fileRef.toString());
        }
    }
}