package com.company.dbperftest.entity;

import io.jmix.core.entity.annotation.JmixGeneratedValue;
import io.jmix.core.metamodel.annotation.InstanceName;
import io.jmix.core.metamodel.annotation.JmixEntity;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JmixEntity
@Table(name = "COMPANY")
@Entity
public class Company {
    @JmixGeneratedValue
    @Column(name = "ID", nullable = false)
    @Id
    private UUID id;

    @InstanceName
    @Column(name = "NAME")
    private String name;

    @JoinTable(name = "COMPANY_COST_UNIT_LINK",
            joinColumns = @JoinColumn(name = "COMPANY_ID", referencedColumnName = "ID"),
            inverseJoinColumns = @JoinColumn(name = "COST_UNIT_ID", referencedColumnName = "ID"))
    @ManyToMany
    private List<CostUnit> relatedCostUnits = new ArrayList<>();

    public List<CostUnit> getRelatedCostUnits() {
        return relatedCostUnits;
    }

    public void setRelatedCostUnits(List<CostUnit> relatedCostUnits) {
        this.relatedCostUnits = relatedCostUnits;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }
}