package com.company.dbperftest.entity;

import io.jmix.core.entity.annotation.JmixGeneratedValue;
import io.jmix.core.metamodel.annotation.*;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JmixEntity
@Table(name = "INVOICE", indexes = {
        @Index(name = "IDX_INVOICE_FROM", columnList = "FROM_ID"),
        @Index(name = "IDX_INVOICE_TO", columnList = "TO_ID")
})
@Entity
public class Invoice {
    @JmixGeneratedValue
    @Column(name = "ID", nullable = false)
    @Id
    private UUID id;

    @Column(name = "INVOICE_NUMBER")
    private String invoiceNumber;

    @JoinColumn(name = "FROM_ID", nullable = false)
    @NotNull
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    private Company from;

    @JoinColumn(name = "TO_ID", nullable = false)
    @NotNull
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    private Company to;

    @JmixProperty
    @Transient
    private BigDecimal tmpAmount;

    @Composition
    @OneToMany(mappedBy = "invoice")
    private List<Note> notes = new ArrayList<>();

    public List<Note> getNotes() {
        return notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public BigDecimal getTmpAmount() {
        return tmpAmount;
    }

    public void setTmpAmount(BigDecimal tmpAmount) {
        this.tmpAmount = tmpAmount;
    }

    @DependsOnProperties(value = {"to", "from"})
    @Transient
    public Company getCompany() {
        if (invoiceNumber != null && invoiceNumber.startsWith("A")) {
            return from;
        }
        return to;
    }


    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Company getTo() {
        return to;
    }

    public void setTo(Company to) {
        this.to = to;
    }

    public Company getFrom() {
        return from;
    }

    public void setFrom(Company from) {
        this.from = from;
    }

    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @InstanceName
    @DependsOnProperties({"from", "invoiceNumber"})
    public String getInstanceName() {
        return String.format("%s %s", from, invoiceNumber);
    }
}