package com.company.dbperftest.view.invoice;

import com.company.dbperftest.entity.Invoice;
import com.company.dbperftest.view.main.MainView;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.view.*;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value = "invoices", layout = MainView.class)
@ViewController("Invoice.list")
@ViewDescriptor("invoice-list-view.xml")
@LookupComponent("invoicesTable")
@DialogMode(width = "50em", height = "37.5em")
public class InvoiceListView extends StandardListView<Invoice> {
    @ViewComponent
    private DataGrid<Invoice> invoicesTable;
    @Autowired
    private UiComponents uiComponents;

    @Subscribe
    public void onInit(InitEvent event) {
        invoicesTable.addComponentColumn(invoice -> {
            VerticalLayout vbox = uiComponents.create(VerticalLayout.class);
            Div div = uiComponents.create(Div.class);
            div.add(invoice.getCompany().getName());
            vbox.add(div);
            return vbox;
        });
    }
}