package com.company.security.entity;

import io.jmix.core.metamodel.annotation.JmixEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;

import java.util.Date;

@JmixEntity
@Table(name = "TCollection")
@Entity
public class TCollection {
	@Column(name = "colIdCollection", nullable = false)
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;

	@Column(name = "colCollectionName", nullable = false, length = 128)
	@NotNull
	private String colCollectionName;

	@Column(name = "colComments", nullable = false)
	@Lob
	@NotNull
	private String colComments;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "colAddDatetime1")
	private Date colAddDatetime1;

	public Date getColAddDatetime1() {
		return colAddDatetime1;
	}

	public void setColAddDatetime1(Date colAddDatetime1) {
		this.colAddDatetime1 = colAddDatetime1;
	}

	public String getColComments() {
		return colComments;
	}

	public void setColComments(String colComments) {
		this.colComments = colComments;
	}

	public String getColCollectionName() {
		return colCollectionName;
	}

	public void setColCollectionName(String colCollectionName) {
		this.colCollectionName = colCollectionName;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

}