package com.company.security.entity;

import io.jmix.core.metamodel.annotation.JmixEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;

@JmixEntity
@Table(name = "tObjects")
@Entity
public class TObject {
	@Column(name = "objIdObject", nullable = false)
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;

	@NotNull
	@Column(name = "objCommonName", nullable = false, length = 64)
	private String objCommonName;

	@Column(name = "objCommonComments")
	@Lob
	private String objCommonComments;

	@Column(name = "objAdminCreator", length = 64)
	private String objAdminCreator;

	public String getObjAdminCreator() {
		return objAdminCreator;
	}

	public void setObjAdminCreator(String objAdminCreator) {
		this.objAdminCreator = objAdminCreator;
	}

	public String getObjCommonComments() {
		return objCommonComments;
	}

	public void setObjCommonComments(String objCommonComments) {
		this.objCommonComments = objCommonComments;
	}

	public String getObjCommonName() {
		return objCommonName;
	}

	public void setObjCommonName(String objCommonName) {
		this.objCommonName = objCommonName;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

}