package com.company.security.security;

import com.company.security.entity.TCollection;
import com.company.security.entity.TObject;
import com.company.security.entity.User;
import io.jmix.security.model.EntityAttributePolicyAction;
import io.jmix.security.model.EntityPolicyAction;
import io.jmix.security.role.annotation.EntityAttributePolicy;
import io.jmix.security.role.annotation.EntityPolicy;
import io.jmix.security.role.annotation.ResourceRole;
import io.jmix.securityflowui.role.annotation.MenuPolicy;
import io.jmix.securityflowui.role.annotation.ViewPolicy;

@ResourceRole(name = "ReadOnlyRole", code = ReadOnlyRole.CODE, scope = "UI")
public interface ReadOnlyRole {
	String CODE = "read-only-role";

	@MenuPolicy(menuIds = {"TCollection.list", "TObject.list"})
	@ViewPolicy(viewIds = {"TCollection.list", "TObject.list", "TObject.detail"})
	void screens();

	@EntityAttributePolicy(entityClass = TCollection.class, attributes = "*", action = EntityAttributePolicyAction.VIEW)
	@EntityPolicy(entityClass = TCollection.class, actions = EntityPolicyAction.READ)
	void tCollection();

	@EntityAttributePolicy(entityClass = TObject.class, attributes = "*", action = EntityAttributePolicyAction.VIEW)
	@EntityPolicy(entityClass = TObject.class, actions = EntityPolicyAction.READ)
	void tObject();

	@EntityAttributePolicy(entityClass = User.class, attributes = "*", action = EntityAttributePolicyAction.VIEW)
	@EntityPolicy(entityClass = User.class, actions = EntityPolicyAction.READ)
	void user();
}