package com.company.security.view.tobject;

import com.company.security.entity.TObject;
import com.company.security.view.main.MainView;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.router.Route;
import io.jmix.core.AccessManager;
import io.jmix.core.Metadata;
import io.jmix.core.MetadataTools;
import io.jmix.core.accesscontext.CrudEntityContext;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Set;


@Route(value = "t-objects", layout = MainView.class)
@ViewController(id = "TObject.list")
@ViewDescriptor(path = "t-object-list-view.xml")
@LookupComponent("tObjectsDataGrid")
@DialogMode(width = "64em")
public class TObjectListView extends StandardListView<TObject>
{
	//  security
	/*private CrudEntityContext ctx = null;
	@Autowired
	private Metadata metadata;
	@Autowired
	private AccessManager accessManager;
	@ViewComponent
	private JmixButton copyAndEditButton;

	@Subscribe
	public void onInit(final InitEvent event) {
		ctx = new CrudEntityContext(metadata.getClass(TObject.class));
		accessManager.applyRegisteredConstraints(ctx);
	}

	@Subscribe
	public void onReady(ReadyEvent event)
	{
		copyAndEditButton.setEnabled(ctx.isUpdatePermitted());
	}
	@Subscribe("tObjectsDataGrid")
	public void onTObjectsDataGridSelection(final SelectionEvent<DataGrid<TObject>, TObject> event) {
		copyAndEditButton.setEnabled(ctx.isUpdatePermitted());
	}*/

	@Autowired
	private CurrentAuthentication currentAuthentication;
	@ViewComponent
	private DataGrid<TObject> tObjectsDataGrid;
	@Autowired
	private DialogWindows dialogWindows;
	@Autowired
	private MetadataTools metadataTools;

	@Subscribe(id = "copyAndEditButton", subject = "clickListener")
	public void onCopyAndEditButtonClick(final ClickEvent<JmixButton> event)
	{
		Set<TObject> tObject = tObjectsDataGrid.getSelectedItems();
		for (TObject object : tObject) {
			TObject tObjectCopy = createCopy(object);

			dialogWindows.detail(tObjectsDataGrid)
					.withViewClass(TObjectDetailView.class)
					.newEntity(tObjectCopy)
					.open();
		}
	}

	protected TObject createCopy(TObject tObject) {
		TObject tObjectCopy = metadataTools.copy(tObject);
		tObjectCopy.setId(null);
		tObjectCopy.setObjAdminCreator(currentAuthentication.getUser().getUsername());
		return tObjectCopy;
	}
}