package ch.jmix.mapextentissue.view.networkmap;

import ch.jmix.mapextentissue.view.main.MainView;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.view.*;
import io.jmix.maps.utils.GeometryUtils;
import io.jmix.mapsflowui.component.GeoMap;
import io.jmix.mapsflowui.component.model.FitOptions;
import io.jmix.mapsflowui.component.model.feature.PolygonFeature;
import io.jmix.mapsflowui.component.model.source.VectorSource;
import io.jmix.mapsflowui.kit.component.model.Easing;
import io.jmix.mapsflowui.kit.component.model.Extent;
import io.jmix.mapsflowui.kit.component.model.style.Fill;
import io.jmix.mapsflowui.kit.component.model.style.PolygonStyle;
import io.jmix.mapsflowui.kit.component.model.style.stroke.Stroke;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

@Route(value = "networkMap", layout = MainView.class)
@ViewController(id = "Networkmap")
@ViewDescriptor(path = "networkMap.xml")
public class Networkmap extends StandardView
{
	@ViewComponent
	private GeoMap networkMap;

	private static final GeometryFactory factory = GeometryUtils.getGeometryFactory();

	@ViewComponent("networkMap.vectorLayer.source")
	private VectorSource source;

	@Subscribe
	public void onInit(final InitEvent event) {

		Extent extent = new Extent(-1.8674325306490491, 44.671768059029716, 6.86824470581692, 45.35320099891573);
		networkMap.getMapView().setExtent(extent);
		// networkMap.setHeight("1%");

		//  create the desired Polygon to display
		Polygon polygon = createPolygon();

		//  add it to the vectorLayer
		source.addFeature(polygonFeature(polygon));

		//  fit the map
		networkMap.fit(new FitOptions(polygon)
				.withDuration(1000)
				.withEasing(Easing.LINEAR)
				.withMaxZoom(20.)
		);
	}

	/*
			creates point to modify the polygon
  */
	public static Polygon createPolygon()
	{
		double minX = -1.8674325306490491;
		double maxX =  6.86824470581692;
		double minY = 44.671768059029716;
		double maxY = 45.35320099891573;

		Coordinate topLeft     = new Coordinate(minX, maxY);
		Coordinate bottomLeft  = new Coordinate(minX, minY);
		Coordinate bottomRight = new Coordinate(maxX, minY);
		Coordinate topRight    = new Coordinate(maxX, maxY);

		return factory.createPolygon(factory.createLinearRing(new Coordinate[]{
				topLeft, bottomLeft, bottomRight, topRight, topLeft}));
	}

	/*
		creates Feature to modify the polygon
*/
	public static PolygonFeature polygonFeature(Polygon polygon)
	{
		PolygonFeature pf = new PolygonFeature(polygon);
		pf.addStyles(
				new PolygonStyle()
						.withFill(new Fill("rgba(68, 123, 212, 0.4)"))    //  fill of polygon
						.withStroke(new Stroke()                                //  border
								.withWidth(2d)
								.withColor("#ff0000"))
						.build());
		return pf;
	}

}