# openapi-java-client

Mi API de ejemplo

- API version: 1.0

- Build date: 2026-01-16T17:33:43.023006200+01:00[Europe/Madrid]

- Generator version: 7.8.0

Documentación de mi API con autenticación OAuth2 (client_credentials)


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 17+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi-java-client</artifactId>
  <version>1.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'openapi-java-client' jar has been published to maven central.
    mavenLocal()       // Needed if the 'openapi-java-client' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:openapi-java-client:1.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi-java-client-1.0.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import com.company.example.books.*;
import com.company.example.books.auth.*;
import com.company.example.books.model.*;
import com.company.example.books.api.BookControllerApi;

public class BookControllerApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = new ApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        BookModel bookModel = new BookModel(); // BookModel | 
        try {
            BookModel result = apiInstance.createBook(bookModel);
            System.out.println(result);
        } catch (HttpStatusCodeException e) {
            System.err.println("Exception when calling BookControllerApi#createBook");
            System.err.println("Status code: " + e.getStatusCode().value());
            System.err.println("Reason: " + e.getResponseBodyAsString());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BookControllerApi* | [**createBook**](docs/BookControllerApi.md#createBook) | **POST** /api/books | 
*BookControllerApi* | [**deleteBook**](docs/BookControllerApi.md#deleteBook) | **DELETE** /api/books/{id} | 
*BookControllerApi* | [**getAllBooks**](docs/BookControllerApi.md#getAllBooks) | **GET** /api/books | 
*BookControllerApi* | [**getBookById**](docs/BookControllerApi.md#getBookById) | **GET** /api/books/{id} | 
*BookControllerApi* | [**updateBook**](docs/BookControllerApi.md#updateBook) | **PUT** /api/books/{id} | 
*TokenControllerApi* | [**generateToken**](docs/TokenControllerApi.md#generateToken) | **POST** /oauth/token | 


## Documentation for Models

 - [BookModel](docs/BookModel.md)
 - [PageBookModel](docs/PageBookModel.md)
 - [PageableObjectModel](docs/PageableObjectModel.md)
 - [SortObjectModel](docs/SortObjectModel.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth


- **Type**: HTTP Bearer Token authentication (JWT)


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



