# BookControllerApi

All URIs are relative to *http://localhost:8080*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createBook**](BookControllerApi.md#createBook) | **POST** /api/books |  |
| [**deleteBook**](BookControllerApi.md#deleteBook) | **DELETE** /api/books/{id} |  |
| [**getAllBooks**](BookControllerApi.md#getAllBooks) | **GET** /api/books |  |
| [**getBookById**](BookControllerApi.md#getBookById) | **GET** /api/books/{id} |  |
| [**updateBook**](BookControllerApi.md#updateBook) | **PUT** /api/books/{id} |  |



## createBook

> BookModel createBook(bookModel)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.BookControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        BookModel bookModel = new BookModel(); // BookModel | 
        try {
            BookModel result = apiInstance.createBook(bookModel);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling BookControllerApi#createBook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **bookModel** | [**BookModel**](BookModel.md)|  | |

### Return type

[**BookModel**](BookModel.md)

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: */*


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## deleteBook

> deleteBook(id)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.BookControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        Long id = 56L; // Long | 
        try {
            apiInstance.deleteBook(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling BookControllerApi#deleteBook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **Long**|  | |

### Return type

null (empty response body)

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## getAllBooks

> PageBookModel getAllBooks(page, size)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.BookControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        Integer page = 0; // Integer | 
        Integer size = 25; // Integer | 
        try {
            PageBookModel result = apiInstance.getAllBooks(page, size);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling BookControllerApi#getAllBooks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **page** | **Integer**|  | [optional] [default to 0] |
| **size** | **Integer**|  | [optional] [default to 25] |

### Return type

[**PageBookModel**](PageBookModel.md)

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: */*


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## getBookById

> BookModel getBookById(id)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.BookControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        Long id = 56L; // Long | 
        try {
            BookModel result = apiInstance.getBookById(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling BookControllerApi#getBookById");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **Long**|  | |

### Return type

[**BookModel**](BookModel.md)

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: */*


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## updateBook

> BookModel updateBook(id, bookModel)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.BookControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        BookControllerApi apiInstance = new BookControllerApi(defaultClient);
        Long id = 56L; // Long | 
        BookModel bookModel = new BookModel(); // BookModel | 
        try {
            BookModel result = apiInstance.updateBook(id, bookModel);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling BookControllerApi#updateBook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **Long**|  | |
| **bookModel** | [**BookModel**](BookModel.md)|  | |

### Return type

[**BookModel**](BookModel.md)

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: */*


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

