# TokenControllerApi

All URIs are relative to *http://localhost:8080*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**generateToken**](TokenControllerApi.md#generateToken) | **POST** /oauth/token |  |



## generateToken

> Object generateToken(grantType, clientId, clientSecret)



### Example

```java
// Import classes:
import com.company.example.books.ApiClient;
import com.company.example.books.ApiException;
import com.company.example.books.Configuration;
import com.company.example.books.auth.*;
import com.company.example.books.models.*;
import com.company.example.books.api.TokenControllerApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP bearer authorization: bearerAuth
        HttpBearerAuth bearerAuth = (HttpBearerAuth) defaultClient.getAuthentication("bearerAuth");
        bearerAuth.setBearerToken("BEARER TOKEN");

        TokenControllerApi apiInstance = new TokenControllerApi(defaultClient);
        String grantType = "grantType_example"; // String | 
        String clientId = "clientId_example"; // String | 
        String clientSecret = "clientSecret_example"; // String | 
        try {
            Object result = apiInstance.generateToken(grantType, clientId, clientSecret);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TokenControllerApi#generateToken");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **grantType** | **String**|  | |
| **clientId** | **String**|  | |
| **clientSecret** | **String**|  | |

### Return type

**Object**

### Authorization

[bearerAuth](../README.md#bearerAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: */*


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

