package com.company.example.books.api;

import com.company.example.books.ApiClient;


import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.client.RestClient.ResponseSpec;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2026-01-16T17:33:43.023006200+01:00[Europe/Madrid]", comments = "Generator version: 7.8.0")
public class TokenControllerApi {
    private ApiClient apiClient;

    public TokenControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public TokenControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * 
     * <p><b>200</b> - OK
     * @param grantType The grantType parameter
     * @param clientId The clientId parameter
     * @param clientSecret The clientSecret parameter
     * @return Object
     * @throws RestClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec generateTokenRequestCreation(String grantType, String clientId, String clientSecret) throws RestClientResponseException {
        Object postBody = null;
        // verify the required parameter 'grantType' is set
        if (grantType == null) {
            throw new RestClientResponseException("Missing the required parameter 'grantType' when calling generateToken", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new RestClientResponseException("Missing the required parameter 'clientId' when calling generateToken", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'clientSecret' is set
        if (clientSecret == null) {
            throw new RestClientResponseException("Missing the required parameter 'clientSecret' when calling generateToken", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "grant_type", grantType));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "client_id", clientId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "client_secret", clientSecret));
        
        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<>() {};
        return apiClient.invokeAPI("/oauth/token", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>200</b> - OK
     * @param grantType The grantType parameter
     * @param clientId The clientId parameter
     * @param clientSecret The clientSecret parameter
     * @return Object
     * @throws RestClientResponseException if an error occurs while attempting to invoke the API
     */
    public Object generateToken(String grantType, String clientId, String clientSecret) throws RestClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<>() {};
        return generateTokenRequestCreation(grantType, clientId, clientSecret).body(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>200</b> - OK
     * @param grantType The grantType parameter
     * @param clientId The clientId parameter
     * @param clientSecret The clientSecret parameter
     * @return ResponseEntity&lt;Object&gt;
     * @throws RestClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Object> generateTokenWithHttpInfo(String grantType, String clientId, String clientSecret) throws RestClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<>() {};
        return generateTokenRequestCreation(grantType, clientId, clientSecret).toEntity(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>200</b> - OK
     * @param grantType The grantType parameter
     * @param clientId The clientId parameter
     * @param clientSecret The clientSecret parameter
     * @return ResponseSpec
     * @throws RestClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec generateTokenWithResponseSpec(String grantType, String clientId, String clientSecret) throws RestClientResponseException {
        return generateTokenRequestCreation(grantType, clientId, clientSecret);
    }
}
