package com.company.example.books;

import com.company.example.books.ApiClient;
import com.company.example.books.api.BookControllerApi;
import com.company.example.books.api.TokenControllerApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Instantiates generated "books" OpenAPI client classes as beans.
 */
@Configuration
public class BooksClientConfiguration {

    @Bean("booksApiClient")
    public ApiClient apiClient(@Value("${example.openapi.client.books.bearer-token}") String bearerToken) {
        ApiClient client = new ApiClient();
        client.setBearerToken(bearerToken);

        return client;
    }

    @Bean("books_BookControllerApi")
    public BookControllerApi bookControllerApi(ApiClient apiClient) {
        return new BookControllerApi(apiClient);
    }

    @Bean("books_TokenControllerApi")
    public TokenControllerApi tokenControllerApi(ApiClient apiClient) {
        return new TokenControllerApi(apiClient);
    }
}

