/*
 * Decompiled with CFR 0.152.
 */
package com.company.users.view.user;

import com.company.users.entity.User;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.router.Route;
import io.jmix.core.EntityStates;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.jmix.multitenancy.core.TenantProvider;
import io.jmix.multitenancyflowui.MultitenancyUiSupport;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;

@Route(value="users/:id", layout=DefaultMainViewParent.class)
@ViewController(value="usr_User.detail")
@ViewDescriptor(value="user-detail-view.xml")
@EditedEntityContainer(value="userDc")
public class UserDetailView
extends StandardDetailView<User> {
    @ViewComponent
    private TypedTextField<String> usernameField;
    @ViewComponent
    private JmixComboBox<String> tenantField;
    @ViewComponent
    private PasswordField passwordField;
    @ViewComponent
    private PasswordField confirmPasswordField;
    @ViewComponent
    private ComboBox<String> timeZoneField;
    @Autowired
    private EntityStates entityStates;
    @ViewComponent
    private MessageBundle messageBundle;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private TenantProvider tenantProvider;
    @Autowired
    private MultitenancyUiSupport multitenancyUiSupport;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.timeZoneField.setItems(List.of(TimeZone.getAvailableIDs()));
        this.tenantField.setItems((Collection)this.multitenancyUiSupport.getTenantOptions());
    }

    @Subscribe
    public void onInitEntity(StandardDetailView.InitEntityEvent<User> event) {
        this.usernameField.setReadOnly(false);
        this.tenantField.setReadOnly(false);
        this.passwordField.setVisible(true);
        this.confirmPasswordField.setVisible(true);
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        String currentTenantId = this.tenantProvider.getCurrentUserTenantId();
        if (!"no_tenant".equals(currentTenantId) && (this.tenantField.getValue() == null || ((String)this.tenantField.getValue()).isBlank())) {
            this.tenantField.setReadOnly(true);
            this.tenantField.setValue((Object)currentTenantId);
        }
    }

    @Subscribe(value="tenantField")
    public void onTenantFieldComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixComboBox<String>, String> event) {
        this.usernameField.setValue(this.multitenancyUiSupport.getUsernameByTenant(this.usernameField.getValue(), (String)event.getValue()));
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity())) {
            this.usernameField.focus();
        }
    }

    @Subscribe
    public void onValidation(StandardDetailView.ValidationEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity()) && !Objects.equals(this.passwordField.getValue(), this.confirmPasswordField.getValue())) {
            event.getErrors().add(this.messageBundle.getMessage("passwordsDoNotMatch"));
        }
    }

    @Subscribe
    protected void onBeforeSave(StandardDetailView.BeforeSaveEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity())) {
            ((User)this.getEditedEntity()).setPassword(this.passwordEncoder.encode((CharSequence)this.passwordField.getValue()));
        }
    }
}

