package com.company.customers.entity;

import com.company.users.entity.BaseTenantEntity;
import com.company.users.entity.User;
import io.jmix.core.metamodel.annotation.InstanceName;
import io.jmix.core.metamodel.annotation.JmixEntity;

import jakarta.persistence.*;

@JmixEntity
@Table(name = "CST_CUSTOMER", indexes = {
        @Index(name = "IDX_CUSTOMER_STAFF_ID", columnList = "STAFF_ID")
})
@Entity(name = "cst_Customer")
public class Customer extends BaseTenantEntity {
    @InstanceName
    @Column(name = "NAME")
    private String name;

    @Column(name = "EMAIL")
    private String email;

    @JoinColumn(name = "STAFF_ID")
    @ManyToOne(fetch = FetchType.LAZY)
    private User staff;

    public User getStaff() {
        return staff;
    }

    public void setStaff(User staff) {
        this.staff = staff;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
