package com.company.products.entity;

import com.company.users.entity.BaseTenantEntity;
import com.company.users.entity.User;
import io.jmix.core.metamodel.annotation.InstanceName;
import io.jmix.core.metamodel.annotation.JmixEntity;

import jakarta.persistence.*;
import java.math.BigDecimal;

@JmixEntity
@Table(name = "PRD_PRODUCT", indexes = {
        @Index(name = "IDX_PRODUCT_MAINTAINER_ID", columnList = "MAINTAINER_ID")
})
@Entity(name = "prd_Product")
public class Product extends BaseTenantEntity {
    @InstanceName
    @Column(name = "NAME")
    private String name;

    @Column(name = "PRICE", precision = 19, scale = 2)
    private BigDecimal price;

    @JoinColumn(name = "MAINTAINER_ID")
    @ManyToOne(fetch = FetchType.LAZY)
    private User maintainer;

    public User getMaintainer() {
        return maintainer;
    }

    public void setMaintainer(User maintainer) {
        this.maintainer = maintainer;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}