package com.company.sales.entity;

import com.company.customers.entity.Customer;
import com.company.users.entity.BaseTenantEntity;
import com.company.users.entity.User;
import io.jmix.core.metamodel.annotation.Composition;
import io.jmix.core.metamodel.annotation.JmixEntity;

import jakarta.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@JmixEntity
@Table(name = "ORDER_", indexes = {
        @Index(name = "IDX_ORDER_SALESPERSON_ID", columnList = "SALESPERSON_ID"),
        @Index(name = "IDX_ORDER_CUSTOMER_ID", columnList = "CUSTOMER_ID")
})
@Entity(name = "Order_")
public class Order extends BaseTenantEntity {
    @Column(name = "DATE_")
    private LocalDate date;

    @Column(name = "NUM")
    private String num;

    @Column(name = "AMOUNT", precision = 19, scale = 2)
    private BigDecimal amount;

    @JoinColumn(name = "SALESPERSON_ID")
    @ManyToOne(fetch = FetchType.LAZY)
    private User salesperson;

    @JoinColumn(name = "CUSTOMER_ID")
    @ManyToOne(fetch = FetchType.LAZY)
    private Customer customer;

    @Composition
    @OneToMany(mappedBy = "order")
    private List<OrderLine> lines;

    public List<OrderLine> getLines() {
        return lines;
    }

    public void setLines(List<OrderLine> lines) {
        this.lines = lines;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public User getSalesperson() {
        return salesperson;
    }

    public void setSalesperson(User salesperson) {
        this.salesperson = salesperson;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

}
