package com.company.layerswitcher.component;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import io.jmix.mapsflowui.component.GeoMap;
import io.jmix.mapsflowui.kit.component.model.MapObservableUtils;
import io.jmix.mapsflowui.kit.component.model.layer.Layer;

@JsModule("./src/layer-switcher/layer-switcher-global.js")
@NpmPackage(value = "ol-layerswitcher", version = "4.1.2")
public class LayerSwitcherMap extends GeoMap {

    public void addLayer(Layer<?> layer, String layerSwitcherName) {
        super.addLayer(layer);

        if (rendered) {
            getElement().executeJs("""
                            setTimeout(() => {
                                console.log('TAAG');
                                const layers = this.olMap.getLayers().getArray();
                                for (const layer of layers) {
                                    const syncId = window.myAppJmixMapObjectsMap.getSyncId(layer);
                                    if (syncId === $0) {
                                        layer.set('title', $1);
                                    }
                                }
                            });
                            """,
                    MapObservableUtils.getSyncId(layer).toString(), layerSwitcherName);
        } else {
            getElement().executeJs("""
                            setTimeout(() => {
                                console.log('TAAG');
                                const layers = this.olMap.getLayers().getArray();
                                for (const layer of layers) {
                                    const syncId = window.myAppJmixMapObjectsMap.getSyncId(layer);
                                    if (syncId === $0) {
                                        layer.set('title', $1);
                                    }
                                }
                            });
                            """,
                    MapObservableUtils.getSyncId(layer).toString(), layerSwitcherName);
        }
    }

    /**
     * Here you can pass options to the layer switcher.
     */
    public void attachLayerSwitcher() {
        if (rendered) {
            getElement().executeJs("""
                    const layerSwitcher = window.initLayerSwitcher({});
                    this.olMap.addControl(layerSwitcher);
                    """);
        } else {
            addPendingJs("""
                    const layerSwitcher = window.initLayerSwitcher({});
                    this.olMap.addControl(layerSwitcher);
                    """);
        }
    }
}
