package com.company.layerswitcher.view.demo;


import com.company.layerswitcher.component.LayerSwitcherMap;
import com.company.layerswitcher.view.main.MainView;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.view.*;
import io.jmix.mapsflowui.component.GeoMap;
import io.jmix.mapsflowui.component.model.layer.TileLayer;
import io.jmix.mapsflowui.component.model.layer.VectorLayer;
import io.jmix.mapsflowui.component.model.source.OsmSource;
import io.jmix.mapsflowui.component.model.source.VectorSource;

@Route(value = "demo-view", layout = MainView.class)
@ViewController(id = "DemoView")
@ViewDescriptor(path = "demo-view.xml")
public class DemoView extends StandardView {

    @ViewComponent
    private LayerSwitcherMap map;

    @Subscribe
    public void onInit(final InitEvent event) {
        TileLayer tileLayer = new TileLayer();
        tileLayer.setSource(new OsmSource());

        map.addLayer(tileLayer, "OSM layer");

        VectorLayer vectorLayer = new VectorLayer();
        vectorLayer.setSource(new VectorSource());

        map.addLayer(vectorLayer, "Data layer");

        map.attachLayerSwitcher();
    }
}