package com.company.layerswitcher.view.demojmixswitcher;


import com.company.layerswitcher.view.main.MainView;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.view.*;
import io.jmix.mapsflowui.component.GeoMap;
import io.jmix.mapsflowui.kit.component.model.layer.Layer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Route(value = "demo-jmix-switcher-view", layout = MainView.class)
@ViewController(id = "DemoJmixSwitcherView")
@ViewDescriptor(path = "demo-jmix-switcher-view.xml")
public class DemoJmixSwitcherView extends StandardView {

    @ViewComponent
    private GeoMap map;
    @ViewComponent
    private MessageBundle messageBundle;

    @Subscribe
    public void onInit(final InitEvent event) {
        createLayersPopover();
    }

    protected void createLayersPopover() {
        Popover popover = new Popover();
        popover.setFor("jmixLayerSwitcherButton");

        CheckboxGroup<Layer<?>> layersCheckboxGroup = new CheckboxGroup<>();
        layersCheckboxGroup.addThemeVariants(CheckboxGroupVariant.LUMO_VERTICAL);
        layersCheckboxGroup.setItems(new ListDataProvider<>(map.getLayers()));
        layersCheckboxGroup.setValue(new HashSet<>(map.getLayers()));
        layersCheckboxGroup.setItemLabelGenerator(layer -> messageBundle.getMessage("map.layer." + layer.getId()));
        layersCheckboxGroup.addValueChangeListener(event -> {
            map.getLayers().forEach(layer ->
                    layer.setVisible(event.getValue().contains(layer)));
        });
        popover.add(layersCheckboxGroup);
        getContent().add(popover);
    }
}